
rm(list = ls())
#library packages
library(limma) 
library(VennDiagram)
library(ggplot2)
expFile="TCGA.TPM_log.txt"           #expression input file
cluFile="metabolismcluster.txt"             #Cluster file
setwd("E:\\metabolism\\LGG\\12.TypeDiff")     

#Read and organize the input file
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)


#read cluster file
cluster=read.table(cluFile, header=T, sep="\t", check.names=F, row.names=1)

#Extract intersection file
sameSample=intersect(colnames(data), row.names(cluster))
data=data[,sameSample]
cluster=cluster[sameSample,]

#Difference analysis
logFCfilter=1
geneList=list()
Type=as.vector(cluster)
design=model.matrix(~0+factor(Type))
colnames(design)=levels(factor(Type))
comp=combn(levels(factor(Type)), 2)
allDiffGenes=c()
for(i in 1:ncol(comp)){
  fit=lmFit(data, design)
  contrast=paste0(comp[2,i], "-", comp[1,i])
  #print(contrast)
  cont.matrix=makeContrasts(contrast, levels=design)
  fit2=contrasts.fit(fit, cont.matrix)
  fit2=eBayes(fit2)
  
  #Output all gene differences
  allDiff=topTable(fit2,adjust='fdr',number=200000)
  allDiffOut=rbind(id=colnames(allDiff),allDiff)
  write.table(allDiffOut, file=paste0(contrast, ".all.txt"), sep="\t", quote=F, col.names=F)
  
  #output difference result
  diffSig=allDiff[with(allDiff, (abs(logFC)>logFCfilter & adj.P.Val < 0.05 )), ]
  diffSigOut=rbind(id=colnames(diffSig),diffSig)
  write.table(diffSigOut, file=paste0(contrast, ".diff.txt"), sep="\t", quote=F, col.names=F)
  geneList[[contrast]]=row.names(diffSig)
}


#save the intersection gene

C1.C2=geneList$`C2-C1`
interGenes=unique(c(C1.C2))
write.table(file="interGene.txt",interGenes,sep="\t",quote=F,col.names=F,row.names=F)

#Save the expression of the intersection genes
interGeneExp=data[interGenes,]
interGeneExp=rbind(id=colnames(interGeneExp), interGeneExp)
write.table(interGeneExp, file="interGeneExp.txt", sep="\t", quote=F, col.names=F)


volcano<-read.table("C2-C1.all.txt",header = T,sep = "\t",row.names = 1)
p.cut=0.05
logFC.cut=1
volcano$type[(volcano$P.Value > p.cut|volcano$P.Value=="NA")|(volcano$logFC < logFC.cut)& volcano$logFC > -logFC.cut] <- "none significant"
volcano$type[volcano$P.Value <= p.cut & volcano$logFC >= logFC.cut] <- "up-regulated"
volcano$type[volcano$P.Value <= p.cut & volcano$logFC <= -logFC.cut] <- "down-regulated"  
p = ggplot(volcano,aes(logFC,-1*log10(P.Value),color=type))       
p + geom_point()

x_lim <- max(volcano$logFC,-allDiff$logFC) 
gg=p + geom_point( size=1) + xlim(-x_lim,x_lim) +labs(allDiff="log2(FC)",y="-log10(P.Value)")+
  scale_color_manual(values =c("#0672C0","grey","#EA534A"))+
  geom_hline(aes(yintercept=-1*log10(p.cut)),colour="black", linetype="dashed") +
  geom_vline(xintercept=c(-logFC.cut,logFC.cut),colour="black", linetype="dashed")
print(gg) 

pdf(file="C2-C1 volcano plot.PDF", width=6, height=6)
gg
dev.off()

